/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.autoplot.dom.ConnectorController;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;

public class Connector
extends DomNode {
    protected String plotA = null;
    public static final String PROP_PLOTA = "plotA";
    protected String plotB;
    public static final String PROP_PLOTB = "plotB";
    private boolean bottomCurtain = true;
    public static final String PROP_BOTTOMCURTAIN = "bottomCurtain";
    private int curtainOpacityPercent = 80;
    public static final String PROP_CURTAINOPACITYPERCENT = "curtainOpacityPercent";
    private boolean fill = false;
    public static final String PROP_FILL = "fill";
    private Color fillColor = new Color(240, 240, 240);
    public static final String PROP_FILLCOLOR = "fillColor";
    private Color color = Color.LIGHT_GRAY;
    public static final String PROP_COLOR = "color";
    private boolean visible = true;
    public static final String PROP_VISIBLE = "visible";
    private ConnectorController controller = null;
    public static final String PROP_CONTROLLER = "controller";

    public Connector() {
        this.plotA = "";
        this.plotB = "";
    }

    public Connector(String plotA, String plotB) {
        this.plotA = plotA;
        this.plotB = plotB;
    }

    public String getPlotA() {
        return this.plotA;
    }

    public void setPlotA(String s) {
        String old = this.plotB;
        this.plotA = s;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTA, old, s);
    }

    public String getPlotB() {
        return this.plotB;
    }

    public void setPlotB(String s) {
        String old = this.plotB;
        this.plotB = s;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTB, old, s);
    }

    public boolean isBottomCurtain() {
        return this.bottomCurtain;
    }

    public void setBottomCurtain(boolean bottomCurtain) {
        boolean oldBottomCurtain = this.bottomCurtain;
        this.bottomCurtain = bottomCurtain;
        this.propertyChangeSupport.firePropertyChange(PROP_BOTTOMCURTAIN, oldBottomCurtain, bottomCurtain);
    }

    public int getCurtainOpacityPercent() {
        return this.curtainOpacityPercent;
    }

    public void setCurtainOpacityPercent(int curtainOpacityPercent) {
        int oldCurtainOpacityPercent = this.curtainOpacityPercent;
        this.curtainOpacityPercent = curtainOpacityPercent;
        this.propertyChangeSupport.firePropertyChange(PROP_CURTAINOPACITYPERCENT, oldCurtainOpacityPercent, curtainOpacityPercent);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        boolean oldFill = this.fill;
        this.fill = fill;
        this.propertyChangeSupport.firePropertyChange(PROP_FILL, oldFill, fill);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        Color oldFillColor = this.fillColor;
        this.fillColor = fillColor;
        this.propertyChangeSupport.firePropertyChange(PROP_FILLCOLOR, oldFillColor, fillColor);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldColor, color);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.propertyChangeSupport.firePropertyChange(PROP_VISIBLE, oldVisible, visible);
    }

    public ConnectorController getController() {
        return this.controller;
    }

    public void setController(ConnectorController controller) {
        ConnectorController oldController = this.controller;
        this.controller = controller;
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROLLER, oldController, controller);
    }

    @Override
    public DomNode copy() {
        Connector result = (Connector)super.copy();
        result.controller = null;
        return result;
    }

    @Override
    public void syncTo(DomNode n) {
        this.syncTo(n, new ArrayList<String>());
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        DomUtil.syncTo(this, n, exclude);
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        return DomUtil.getDiffs(this, node);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Connector)) {
            return false;
        }
        Connector that = (Connector)obj;
        return that.plotA.equals(this.plotA) && that.plotB.equals(this.plotB);
    }

    public int hashCode() {
        return this.plotA.hashCode() + this.plotB.hashCode();
    }

    @Override
    public String toString() {
        return this.plotA + " to " + this.plotB;
    }
}

